"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Content
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApprovalCreateInstance = exports.ApprovalCreateListInstance = exports.ContentApprovalRequest = void 0;
const util_1 = require("util");
const deserialize = require("../../../../base/deserialize");
const serialize = require("../../../../base/serialize");
const utility_1 = require("../../../../base/utility");
/**
 * Content approval request body
 */
class ContentApprovalRequest {
}
exports.ContentApprovalRequest = ContentApprovalRequest;
function ApprovalCreateListInstance(version, contentSid) {
    if (!(0, utility_1.isValidPathParam)(contentSid)) {
        throw new Error("Parameter 'contentSid' is not valid.");
    }
    const instance = {};
    instance._version = version;
    instance._solution = { contentSid };
    instance._uri = `/Content/${contentSid}/ApprovalRequests/whatsapp`;
    instance.create = function create(params, headers, callback) {
        if (params === null || params === undefined) {
            throw new Error('Required parameter "params" missing.');
        }
        let data = {};
        data = params;
        if (headers === null || headers === undefined) {
            headers = {};
        }
        headers["Content-Type"] = "application/json";
        headers["Accept"] = "application/json";
        let operationVersion = version, operationPromise = operationVersion.create({
            uri: instance._uri,
            method: "post",
            data,
            headers,
        });
        operationPromise = operationPromise.then((payload) => new ApprovalCreateInstance(operationVersion, payload, instance._solution.contentSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    };
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.ApprovalCreateListInstance = ApprovalCreateListInstance;
class ApprovalCreateInstance {
    constructor(_version, payload, contentSid) {
        this._version = _version;
        this.name = payload.name;
        this.category = payload.category;
        this.contentType = payload.content_type;
        this.status = payload.status;
        this.rejectionReason = payload.rejection_reason;
        this.allowCategoryChange = payload.allow_category_change;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            name: this.name,
            category: this.category,
            contentType: this.contentType,
            status: this.status,
            rejectionReason: this.rejectionReason,
            allowCategoryChange: this.allowCategoryChange,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.ApprovalCreateInstance = ApprovalCreateInstance;
