"use strict";
/*
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Numbers
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PortingPortInPhoneNumberListInstance = exports.PortingPortInPhoneNumberInstance = exports.PortingPortInPhoneNumberContextImpl = void 0;
const util_1 = require("util");
const deserialize = require("../../../base/deserialize");
const serialize = require("../../../base/serialize");
const utility_1 = require("../../../base/utility");
class PortingPortInPhoneNumberContextImpl {
    constructor(_version, portInRequestSid, phoneNumberSid) {
        this._version = _version;
        if (!(0, utility_1.isValidPathParam)(portInRequestSid)) {
            throw new Error("Parameter 'portInRequestSid' is not valid.");
        }
        if (!(0, utility_1.isValidPathParam)(phoneNumberSid)) {
            throw new Error("Parameter 'phoneNumberSid' is not valid.");
        }
        this._solution = { portInRequestSid, phoneNumberSid };
        this._uri = `/Porting/PortIn/${portInRequestSid}/PhoneNumber/${phoneNumberSid}`;
    }
    remove(callback) {
        const headers = {};
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.remove({
            uri: instance._uri,
            method: "delete",
            headers,
        });
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    fetch(callback) {
        const headers = {};
        headers["Accept"] = "application/json";
        const instance = this;
        let operationVersion = instance._version, operationPromise = operationVersion.fetch({
            uri: instance._uri,
            method: "get",
            headers,
        });
        operationPromise = operationPromise.then((payload) => new PortingPortInPhoneNumberInstance(operationVersion, payload, instance._solution.portInRequestSid, instance._solution.phoneNumberSid));
        operationPromise = instance._version.setPromiseCallback(operationPromise, callback);
        return operationPromise;
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return this._solution;
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.PortingPortInPhoneNumberContextImpl = PortingPortInPhoneNumberContextImpl;
class PortingPortInPhoneNumberInstance {
    constructor(_version, payload, portInRequestSid, phoneNumberSid) {
        this._version = _version;
        this.portInRequestSid = payload.port_in_request_sid;
        this.phoneNumberSid = payload.phone_number_sid;
        this.url = payload.url;
        this.accountSid = payload.account_sid;
        this.phoneNumberType = payload.phone_number_type;
        this.dateCreated = deserialize.iso8601DateTime(payload.date_created);
        this.country = payload.country;
        this.missingRequiredFields = payload.missing_required_fields;
        this.lastUpdated = deserialize.iso8601DateTime(payload.last_updated);
        this.phoneNumber = payload.phone_number;
        this.portable = payload.portable;
        this.notPortabilityReason = payload.not_portability_reason;
        this.notPortabilityReasonCode = deserialize.integer(payload.not_portability_reason_code);
        this.portInPhoneNumberStatus = payload.port_in_phone_number_status;
        this.portOutPin = deserialize.integer(payload.port_out_pin);
        this.rejectionReason = payload.rejection_reason;
        this.rejectionReasonCode = deserialize.integer(payload.rejection_reason_code);
        this.portDate = deserialize.iso8601DateTime(payload.port_date);
        this._solution = {
            portInRequestSid: portInRequestSid || this.portInRequestSid,
            phoneNumberSid: phoneNumberSid || this.phoneNumberSid,
        };
    }
    get _proxy() {
        this._context =
            this._context ||
                new PortingPortInPhoneNumberContextImpl(this._version, this._solution.portInRequestSid, this._solution.phoneNumberSid);
        return this._context;
    }
    /**
     * Remove a PortingPortInPhoneNumberInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed boolean
     */
    remove(callback) {
        return this._proxy.remove(callback);
    }
    /**
     * Fetch a PortingPortInPhoneNumberInstance
     *
     * @param callback - Callback to handle processed record
     *
     * @returns Resolves to processed PortingPortInPhoneNumberInstance
     */
    fetch(callback) {
        return this._proxy.fetch(callback);
    }
    /**
     * Provide a user-friendly representation
     *
     * @returns Object
     */
    toJSON() {
        return {
            portInRequestSid: this.portInRequestSid,
            phoneNumberSid: this.phoneNumberSid,
            url: this.url,
            accountSid: this.accountSid,
            phoneNumberType: this.phoneNumberType,
            dateCreated: this.dateCreated,
            country: this.country,
            missingRequiredFields: this.missingRequiredFields,
            lastUpdated: this.lastUpdated,
            phoneNumber: this.phoneNumber,
            portable: this.portable,
            notPortabilityReason: this.notPortabilityReason,
            notPortabilityReasonCode: this.notPortabilityReasonCode,
            portInPhoneNumberStatus: this.portInPhoneNumberStatus,
            portOutPin: this.portOutPin,
            rejectionReason: this.rejectionReason,
            rejectionReasonCode: this.rejectionReasonCode,
            portDate: this.portDate,
        };
    }
    [util_1.inspect.custom](_depth, options) {
        return (0, util_1.inspect)(this.toJSON(), options);
    }
}
exports.PortingPortInPhoneNumberInstance = PortingPortInPhoneNumberInstance;
function PortingPortInPhoneNumberListInstance(version) {
    const instance = ((portInRequestSid, phoneNumberSid) => instance.get(portInRequestSid, phoneNumberSid));
    instance.get = function get(portInRequestSid, phoneNumberSid) {
        return new PortingPortInPhoneNumberContextImpl(version, portInRequestSid, phoneNumberSid);
    };
    instance._version = version;
    instance._solution = {};
    instance._uri = ``;
    instance.toJSON = function toJSON() {
        return instance._solution;
    };
    instance[util_1.inspect.custom] = function inspectImpl(_depth, options) {
        return (0, util_1.inspect)(instance.toJSON(), options);
    };
    return instance;
}
exports.PortingPortInPhoneNumberListInstance = PortingPortInPhoneNumberListInstance;
